*******************************************************************************
*                        680xx Grundprogramm mendiv3                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                 Diverse Unterprogramme der Mensteuerung                    *
*******************************************************************************


getstx:                         * Adresse Editor holen
 move.l stxtxt(a5),d0
rts

putstx:                         * Adresse Editor setzen
 move.l d0,stxtxt(a5)
 move.l d0,akttxt(a5)
 movea.l d0,a0                  * Adresse nach a0
put1stx:
 tst.b (a0)+                    * Bis Null gefunden
 bne.s put1stx
 subq.l #1,a0                   * 1 Byte zurck
 move.l a0,etxtxt(a5)           * Ende gesetzt
rts

setxor:                         * XOR-Mode fr GDP setzen
 and.b #$f,d0
 move.b d0,xormode(a5)
bra aktpage                     * Aktuelle Seite setzen und XOR-Mode

getxor:                         * XOR-Mode nach d0
 moveq #0,d0
 move.b xormode(a5),d0
rts

setcolor:                       * Farbe setzen
 move.b d0,fgcolor(a5)          * Farbe merken
 move.b d1,bgcolor(a5)
bra aktpage                     * Seite und Farbe setzen

getcolor:                       * Farbe holen
 clr d0
 clr d1
 move.b fgcolor(a5),d0
 move.b bgcolor(a5),d1
rts

settrans:                       * Tranparent-Modus der GDP-FPGA setzen/lschen
 and.b #$1, d0                  * nur Bit #0
 move.b d0,transmod(a5)
bra aktpage

gettrans:                       * Transparent-Modus der GDP-FPGA holen
 moveq #0, d0
 move.b transmod(a5), d0
rts
 
curonein:                       * Cursor einschalten
 move.b #1,curon(a5)
rts

curonaus:                       * Cursor ausschalten
 clr.b curon(a5)
rts

getbasis:                       * Basisadresse Grundprogramm laden
 lea basis(pc),a0
 move.l a0,d0
rts

getvar:                         * Variablenadresse laden
 lea basis(pc),a0
 adda.l ramstart(pc),a0
 move.l a0,d0
rts

seta5:                          * a5 neu setzen
 lea basis(pc),a5
 adda.l ramstart(pc),a5
rts

getfrei:                        * Adresse hinter Symboltabelle ermitteln
 lea    symtab+symlen(a5),a0
 bsr.s  getnext
 adda.l d0,a0                   * Ende Symboltabelle + Sicherheitsabstand
rts

getsymtab:                      * Adresse Symboltabelle holen
 lea symtab(a5),a0
 move.l a0,d0
rts

getnext:                        * Lnge Symboltabelle holen
 moveq #0,d0
 move symnext(a5),d0
rts

putnext:                        * Adresse fr nchsten Symboltabelleneintrag
 move d0,symnext(a5)            * setzen
rts

getvers:                        * Versionsnummer laden
 move.l versnum(pc),d0
rts

getsn:                          * Seriennummer laden
 move.l snnum(pc),d0
rts

getorg:                         * Assemblerzieladresse holen
 move.l pcorg(a5),d0
rts

putorg:                         * Adresse setzen
 move.l d0,pcorg(a5)
rts

crtex:                          * Ausgabe auf Screen
 move.b #2,iostat(a5)
rts

lstex:                          * Ausgabe auf Drucker
 move.b #3,iostat(a5)
rts

usrex:                          * Ausgabe auf Benutzervektor
 move.b #5,iostat(a5)
rts

serex:                          * co2 auf serielle Karte umlenken
 btst.b #2,ioflag(a5)           * SER?
 bne.s serex1
 btst.b #3,ioflag(a5)           * SER2?
 beq carset                     * Keine SER vorhanden
serex1:
 move.b #6,iostat(a5)
bra carres                      * OK

nilex:                          * Ausgabe ins Leere
 clr errflag(a5)
erraus:                         * Nur Fehlerausgabe
 move.b #1,iostat(a5)
rts

seraus:                         * Umlenkung auf serielle Karte
 btst.b #2,ioflag(a5)           * SER?
 bne.s seraus1
 btst.b #3,ioflag(a5)           * SER2?
 beq carset                     * Keine Umschaltung, wenn keine SER vorhanden
seraus1:
 move.b d0,serflag(a5)
bra carres                      * OK

seterr:                         * Fehlerflag setzen
 move d0,errflag(a5)
rts

geterr:                         * Fehlerflag holen
 move errflag(a5),d0
rts

setpass:                        * Passflag setzen
 move d0,passflag(a5)
rts

gdpvers:                        * GDP-Version abfragen
 moveq #0,d0
 move.b ioflag(a5),d0           * 0 = Alte GDP / 1 = Neue GDP
 and.b #1,d0
rts

asserr:                         * Fehleranzahl nach d0.l
 moveq #0,d0                    * Wort innerhalb eines Langwortes
 move errcnt(a5),d0
rts

getcurxy:                       * Cursor Position nach d1.l / d2.l
 moveq #0,d1                    * Byte innerhalb Langwort
 moveq #0,d2
 move.b curx(a5),d1
 move.b cury(a5),d2
rts

setcurxy:                       * Neuer Cursor d1=curx d2=cury
 movem.l d1-d2,-(a7)
 move.b d1,curx(a5)
 move.b d2,cury(a5)
 bsr aktcur                     * Cursor mit neuen Werten setzen
 movem.l (a7)+,d1-d2
rts

setflip:                        * Seitenumschaltung
 move.b d0,flip(a5)             * d0 = flip0
 move.b d0,flipcnt(a5)          * Doppelseite
 move.b d1,flip1(a5)            * d1 = flip1
 move.b d1,flip1cnt(a5)         * Viererseite
rts

setgroe:                        * Setzt Zeichengre fr co2 etc.
 move.b d0,groesse(a5)          * Gre $11 und $21 sinnvoll
 move d0,-(a7)                  * Andere sind denkbar
 and #$f,d0                     * Y-Vergrerung lassen
 cmp #1,d0                      * 1 ?
 beq.s setgroe1                 * Ja, dann OK
 clr.b cotempo(a5)              * Sonst nur Software-Scroll erlaubt
setgroe1:                       * ACHTUNG !!!
 move (a7)+,d0                  * Dieses Programm darf nicht whrend der CO2-
rts                             * Ausgabe benutzt werden


                            